/**
* \file: adit_bdcl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef PLATFORM_BDCL_INIT_ADIT_BDCL_INCLUDE_ADIT_BDCL_H_
#define PLATFORM_BDCL_INIT_ADIT_BDCL_INCLUDE_ADIT_BDCL_H_
#include <string.h>
#include <chrono>             // std::chrono::seconds
#include <mutex>              // std::mutex, std::unique_lock
#include <condition_variable> // std::condition_variable, std::cv_status
#include <memory>
#include <bdcl/bdclErrorCodes.h>
#include <bdcl/CCarLifeLib.h>
#include <bdcl/AditBaiduCore.h>

//connection pattern setting
#define ADB_CONNECTION 0
#define IOS_WIFI_CONNECTION 1
#define CONNECTION_PATTERN ADB_CONNECTION

namespace adit { namespace bdcl {

class CoreCallbackDealer;
class BaiduCoreReceiver;

/** @class  abdcl
 *  @brief abdcl class acts as proxy between the Baidu Stack and platform adaptations.
 *  Mother Company has to inherites the abdcl class.
 *  Baidu Stack header is included in abdcl header file so the MC can directly access the
 *  callbacks and features of Baidu Stack  . */
class abdcl
{

public:
    abdcl();
    ~abdcl();

    void registerAditBaiduCoreCallbacks(IAditBaiduCoreCallbacks* inAditBaiduCoreCallbacks);

    /**
     * @brief MC has to pass time out for protocol match status.
     * @param timeOut has to populate by MC.
     * Once this function is called the ADIT will copy the info and retry to send the protocol
     * version to MD every second till timeout or Success. Default value is 8 seconds if MC wont
     * set the timeout value*/
    void setProtocolStatusTimeOut(uint16_t timeOut);
    /**
     * @brief MC has to pass StatisticsInfo to ADIT.
     * @param S_STATISTICS_INFO * info Statistic Info along with valid Channel number has to populate by MC.
     * Once this function is called the ADIT will copy the info and maintain the local copy*/
    void setCarLifeStaticsInfo(S_STATISTICS_INFO * info);
    /**
     * @brief MC has to call this start the baidu session.
     * bdclInit will create the CarLife instance and create the 5 recieving thread
     * register the baidu callbacks which ADIT consumes and take care sending
     * Head Unit protocol version and statistic info.
     * @param int aoapAccessoryId aoap accessory Id,
     * @param int aoapDeviceId aoap device Id
     * @retun bdclInitStatus enumeration value of error*/
    bdclInitStatus bdclInit(int aoapAccessoryId, int aoapDeviceId);
    /**
     * @brief MC has to call this start the baidu session with iOS device.
     * MC application must create a EA native transport session with iPhone
     * and get read (/dev/ffs/ep3)and write(/dev/ffs/ep4) file names.
     * bdclInit() will open these files and perform read write operation.
     * bdclInit will create the CarLife instance and create the 5 recieving thread
     * register the baidu callbacks which ADIT consumes and take care sending
     * Head Unit protocol version and statistic info.
     * @param int write file name (/dev/ffs/ep3)
     * @param int read file name (/dev/ffs/ep4)
     * @retun bdclInitStatus enumeration value of error*/
    bdclInitStatus bdclInit(const char* wFile, const char* rFile);

    /**
     * @brief MC has to call this function to Abort the Init call.
     * Once this function is called the ADIT will Abort baidu session
     * and free all the endpoints and terminates the all threads*/
    void bdclAbortInit(void);
    /**
     * @brief MC has to call this function to terminate the baidu session.
     * this function has to be called once the bdclInit returns with success
     * otherwise bdclAbortInit has to call.
     * Once this function is called the ADIT will terminate the baidu session
     * free all the endpoints and terminates the all threads*/
    void teardown(void);

    // video related the baidu callbacks
    static void cmdProtocolVersionMatchStatus(S_PROTOCOL_VERSION_MATCH_SATUS* status);
    static void cmdRegisterMdAuthenResponse(S_MD_AUTHEN_RESULT* result);
    static void cmdRegisterFeatureConfigRequest();
    /**
     * @brief Error call back registered with baidu stack.
     * any where from the baidu stack can call this function to report the error
     * to upper layer
     * @param void *bdclCtx adit bdcl context pointer
     * @param carLifeERROR outError enum error value*/
    static void carLifeErrorCallback(void *bdclCtx, carLifeERROR outError);

    static void* _VideoHeartBeatThread(void* arg)
    {
        static_cast<abdcl*>(arg)->sendVideoHeartBeat();
        return NULL;
    };

private:
    std::unique_ptr<BaiduCoreReceiver> mCoreReceiver;
    static IAditBaiduCoreCallbacks* mBaiduCoreCallbacks;

    S_STATISTICS_INFO * carlifeStaticsInfo; //channel Id has to mention inorder to get uninterrupted baidu session.
    S_FEATURE_CONFIG *mConfigStructArray;
    static bool vrRunning;

    S_HU_PROTOCOL_VERSION huProtocolVersion={1,0};
   
    static std::condition_variable cvBdclInit;
    static std::mutex mutBdclInit;
    static bool initConditionalFlag;
    static bool initCmdFlag;
    std::cv_status huProtocolStatus;


    static std::condition_variable cvInitAuthentication;
    static std::mutex mutInitAuthentication;
    static bool initAuthenticationFlag;
    static bool authenticationResult;

    std::condition_variable cvHeartBeatThread;
    std::mutex mutHeartBeatThread;
    bool heartBeatThreadTerminationFlag;
    pthread_t heartBeatThreadId;


    uint16_t protocolStatusTimeout;

    void registerBaiduCallBacks(void);
    void sendVideoHeartBeat();

};

} } //namespace adit // namespace bdcl

#endif /* PLATFORM_BDCL_INIT_ADIT_BDCL_INCLUDE_ADIT_BDCL_H_ */
